#include "port.h"
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>

/* Get the current statistics on the cpu */
int cpu(int pstat){
  int nidle, nnice, nsystem, nuser;
  int total, len, status;
  int user, nice, system, idle;
  static int last_user, last_nice, last_system, last_idle;
  char buf[5000], dummy[1024];

  len=read(pstat,buf,sizeof(buf));
  status=sscanf(buf,"%s %d %d %d %d",dummy, &user, &nice, &system, &idle);

  nidle=idle-last_idle;
  nuser=user-last_user;
  nsystem=system-last_system;
  nnice=nice-last_nice;

  total=nnice+nsystem+nuser+nidle;

  last_nice=nice;
  last_user=user;
  last_system=system;
  last_idle=idle;

  return(total-nidle);
}

int loop(void){
  int pstat;
  int load;
  char lights;
  int showbeat=1, heartbeat=1, last=0;

  if((pstat=open("/proc/stat",O_RDONLY))==-1){
    printf("Unable to open /proc/stat");
    exit(0);
  }
  
  if(ioperm(0x378,1,1)){
    fprintf(stderr,"Cannot open device, ioperm error.\n");
    exit(1);
  }

  while(1){
    lights=0;

    heartbeat++;
    if(heartbeat>10){
      showbeat=showbeat*-1;;
      heartbeat=0;
    }

    lseek(pstat,0,SEEK_SET);
    load=cpu(pstat)/1.5;
    if(load>last) last++;
    if((load<last) && (last>0)) last--;

    if(last>7)last=7;
    load=last;
    for( ; load > 0; load--)
      lights |= 1 << (load-1);

    if(showbeat>0) lights |= 1 << 7;
    port_out(0x378,lights);
    usleep(100000);
  }
  return(1);
}

int main(char *argv, char **argc){
  pid_t id;

  if((id=fork())!=-1){
    if(id==0){
      setsid();
      loop();
    } else printf("CPU Status Daemon Started!\n");
  } else printf("Could not fork!\n");
  return(0);
}



