/*****************************************************************************\
*   sys_calls - Useful system functions for programming                       *
*                                                                             *
*   Copyright (C) 2001-2002 by Peter Pfrang  <peter.pfrang@gmx.de>            *
*   Version  1.0                                                              *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software Foundation,   *
*   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.            *
\*****************************************************************************/

#include "sys_calls.h"


/* start process as daemon */
int to_daemon(void)
{
	pid_t	pid;
	if ( (pid = fork ()) < 0 )
		return (-1); /* Daemoning not successful */
	else if (pid != 0)
		exit(0); /* Parent-process exits without error */
	/* This part is executed from the child only */
	setsid();	/* Child is going to be session leader */
	chdir ("/");	/* Change to the root directory */
	umask(0);	/* Change the file creation mask */
	return(0);
} /* End to_daemon */


int system_like (char *command)
{
  int success = 0;
  pid_t pid;

/* system call for the command */

	/* fork not successful */
	if ((pid=fork()) < 0)
	{
	// an error occured during fork of the process
	success=-9;
 	printf ("\nError during fork!!\n");
	}
	// child proccess => executes the selected command
	else if (pid == 0)
	{
	// if ((success=execve(shell[0],command_exe,NULL)) == -1)  execve was not successful

	/* printf ("\nChild: executing command\n"); */

	/* execution of the command */
	success=execve(command,NULL,NULL);

	printf ("Child: execution returned: %d\n",success);
	/* execve was not successful - normally this should never happen */
        exit (success);
	}
	else
	/* parent process => waiting for child to exit and its return status */
	{
	/* wait for the executed command to finish the return value is stored in success */
	waitpid(pid,&success,0);
	}

return(success); 
} /* End system_like */
