/* Swedish characters for lcdmod
 *
 * Thanks to Erik Zetterberg <mr.z@linux.se>
 * 
 * Description: Adds support for the last three last letters in the
 * swedish alphabet (a/A with ring above, a/A with diaeresis and o/O
 * with diaeresis). And maps the location of where they should be 
 * according to the ISO-8859-1 character set to their location in CGRAM.
 *
 */

extern char charmap[];

void init_charmap()
{
	charmap[ 0xe5 ] = 0;
	charmap[ 0xe4 ] = 1;
	charmap[ 0xf6 ] = 2;
	charmap[ 0xc5 ] = 3;
	charmap[ 0xc4 ] = 4;
	charmap[ 0xd6 ] = 5;
}

unsigned char cg0[] = { 0x04, 0x00, 0x0e, 0x01, 0x0f, 0x11, 0x0f, 0x00 };
unsigned char cg1[] = { 0x0a, 0x00, 0x0e, 0x01, 0x0f, 0x11, 0x0f, 0x00 };
unsigned char cg2[] = { 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00 };
unsigned char cg3[] = { 0x04, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x11, 0x00 };
unsigned char cg4[] = { 0x0a, 0x00, 0x0e, 0x11, 0x1f, 0x11, 0x11, 0x00 };
unsigned char cg5[] = { 0x0a, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e, 0x00 };
unsigned char cg6[] = { 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f };
unsigned char cg7[] = { 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f };
